/*
 * Decompiled with CFR 0.152.
 */
package panther.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SingleLineFormatter
extends Formatter {
    private static final DateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static String LINE_SEP = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        Date date = new Date(logRecord.getMillis());
        Object object = df;
        synchronized (object) {
            stringBuffer.append(df.format(date));
        }
        stringBuffer.append(':');
        stringBuffer.append(logRecord.getLevel().getLocalizedName()).append(':');
        stringBuffer.append(this.formatMessage(logRecord));
        stringBuffer.append(LINE_SEP);
        if (logRecord.getThrown() != null) {
            try {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(((StringWriter)object).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

